#ifndef USCI_LIB
#define USCI_LIB

#define I2CCLOCKPRESCALER 10                // Set I2C clock rate (SCL=100 kHz)

#define SDA_PIN 0x02                        // msp430x261x UCB0SDA pin
#define SCL_PIN 0x04                        // msp430x261x UCB0SCL pin

void TI_USCI_I2CRead(unsigned char slaveAddr, int length,
                     unsigned char multi, unsigned char *data);
void TI_USCI_I2CWrite(unsigned char slaveAddr, int length,
                      unsigned char multi, unsigned char *data);

void TI_USCI_I2C_receiveinit(unsigned char slave_address,
                             unsigned char prescale);
void TI_USCI_I2C_transmitinit(unsigned char slave_address,
                              unsigned char prescale);


void TI_USCI_I2C_receive(unsigned char byteCount, unsigned char *field);
void TI_USCI_I2C_transmit(unsigned char byteCount, unsigned char *field);


unsigned char TI_USCI_I2C_slave_present(unsigned char slave_address);
unsigned char TI_USCI_I2C_notready();


#endif
